// ** I18N

// Calendar SV language (Swedish, svenska)
// Author: Mihai Bazon, <mihai_bazon@yahoo.com>
// Translation team: <sv@li.org>
// Translator: Leonard Norrgrd <leonard.norrgard@refactor.fi>
// Last translator: Leonard Norrgrd <leonard.norrgard@refactor.fi>
// Encoding: iso-latin-1
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
("sndag",
 "mndag",
 "tisdag",
 "onsdag",
 "torsdag",
 "fredag",
 "lrdag",
 "sndag");

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn't absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.
Calendar._SDN_len = 2;
Calendar._SMN_len = 3;

// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 1;

// full month names
Calendar._MN = new Array
("januari",
 "februari",
 "mars",
 "april",
 "maj",
 "juni",
 "juli",
 "augusti",
 "september",
 "oktober",
 "november",
 "december");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "Om kalendern";

Calendar._TT["ABOUT"] =
"DHTML Datum/tid-vljare\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don't translate this this ;-)
"Fr senaste version g till: http://www.dynarch.com/projects/calendar/\n" +
"Distribueras under GNU LGPL.  Se http://gnu.org/licenses/lgpl.html fr detaljer." +
"\n\n" +
"Val av datum:\n" +
"- Anvnd knapparna \xab, \xbb fr att vlja r\n" +
"- Anvnd knapparna " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + " fr att vlja mnad\n" +
"- Hll musknappen nedtryckt p ngon av ovanstende knappar fr snabbare val.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Val av tid:\n" +
"- Klicka p en del av tiden fr att ka den delen\n" +
"- eller skift-klicka fr att minska den\n" +
"- eller klicka och drag fr snabbare val.";

Calendar._TT["PREV_YEAR"] = "Fregende r (hll fr menu)";
Calendar._TT["PREV_MONTH"] = "Fregende mnad (hll fr menu)";
Calendar._TT["GO_TODAY"] = "G till dagens datum";
Calendar._TT["NEXT_MONTH"] = "Fljande mnad (hll fr menu)";
Calendar._TT["NEXT_YEAR"] = "Fljande r (hll fr menu)";
Calendar._TT["SEL_DATE"] = "Vlj datum";
Calendar._TT["DRAG_TO_MOVE"] = "Drag fr att flytta";
Calendar._TT["PART_TODAY"] = " (idag)";
Calendar._TT["MON_FIRST"] = "Visa mndag frst";
Calendar._TT["SUN_FIRST"] = "Visa sndag frst";
Calendar._TT["CLOSE"] = "Stng";
Calendar._TT["TODAY"] = "Idag";
Calendar._TT["TIME_PART"] = "(Skift-)klicka eller drag fr att ndra tid";
Calendar._TT["DAY_FIRST"] = "Visa %s frst";
Calendar._TT["WEEKEND"] = "0,6";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%Y-%m-%d";
Calendar._TT["TT_DATE_FORMAT"] = "%A %d %b %Y";

Calendar._TT["WK"] = "vecka";
Calendar._TT["TIME"] = "tid:";